<?php 
session_start();
include 'assets/constant/config.php';

try {
        $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        }
        catch(PDOException $e)
        {
        echo "Connection failed: " . $e->getMessage();
        }
?><!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title></title>
    <!-- FullCalendar CSS -->
    <link href='fullcalendar/lib/main.css' rel='stylesheet' />
</head>
<body>
    <div id='calendar'></div>
    <!-- FullCalendar JS -->
    <script src='fullcalendar/lib/main.js'></script>
    <!-- PHP script for fetching events -->
    <script src='fetch_events.php'></script>
</body>
</html>
<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function() {
    var calendarEl = document.getElementById('calendar');
    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth',
        events: 'fetch_events.php' // URL to fetch events
    });
    calendar.render();
});
</script><!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->