<?php 
session_start();
include '../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>
<!-- Top Bar End -->
<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->
<div class="page-content-wrapper ">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">
                    <h4 class="page-title">Campaign</h4>
                </div>
            </div>
            <div class="clearfix"></div>
        </div>
        <!-- end page title end breadcrumb -->

        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;" enctype="multipart/form-data">
                                <thead>
                                   <!--  <tr>
                                        <th>ID</th>
                                        <th>Member</th>
                                        <th>Amount</th>
                                        <th>Date</th>
                                        <th>Note</th>
                                    </tr> -->
                                </thead>
                                <tbody>
                                    <?php
                                    // Fetch campaign details
                                    $stmt = $conn->prepare("SELECT * FROM `campaign` WHERE id = ? AND delete_status = '0'");
                                    $stmt->bindParam(1, $_POST['id'], PDO::PARAM_INT);
                                    $stmt->execute();
                                    $campaigns = $stmt->fetchAll();

                                    foreach ($campaigns as $campaign) { ?>
                                        <tr>
                                            <td><?php echo $campaign['id']; ?></td>
                                            <td colspan="4"><h5><?php echo $campaign['cam_name']; ?></h5></td>
                                        </tr>
                                        <tr>
                                            <th>ID</th>
                                            <td><?php echo $campaign['id']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Date</th>
                                            <td>Start Date: <?php echo $campaign['sdate']; ?>, End Date: <?php echo $campaign['edate']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Progress</th>
                                            <td>Goal: <?php echo $campaign['goal']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Status</th>
                                            <td><?php echo $campaign['status']; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Notes</th>
                                            <td><?php echo $campaign['notes']; ?></td>
                                        </tr>
                                    <?php } ?>

                                    
                                </tbody>
                            </table>
                        </div><!-- end /tableresponsive -->
                    </div><!-- end card-body -->
                </div><!-- end card -->
            </div><!-- end col -->
        </div><!-- end row -->



 <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">

                            <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;" >
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Member</th>
                                        <th>Name</th>
                                        <th>Date</th>
                                        <th>Notes</th>
                                       
                                    </tr>
                                </thead>
                                <tbody>

                                    <?php
                                      // Fetch members related to the specific campaign
                                    $stmt = $conn->prepare("SELECT m.id, m.name, c.goal AS campaign_amount, c.cam_name, c.sdate, c.notes FROM `member` m LEFT JOIN `campaign` c ON m.id = c.id WHERE c.id = ? AND m.delete_status = '0'");
                                    $stmt->bindParam(1, $_POST['id'], PDO::PARAM_INT);
                                    $stmt->execute();
                                    $members = $stmt->fetchAll();

                                    foreach ($members as $member) { ?>


                                        <tr>

                                           
                                           <td> <?php echo $member['id']; ?></td> 
                                                 
                                                 <td><?php echo $member['name']; ?></td>

                                              <td><?php echo $member['campaign_amount']; ?></td>
                                             <td><?php echo $member['sdate']; ?></td>
                                             <td><?php echo $member['notes']; ?></td>


                                            
                                        </tr>
                                    <?php  } ?>
                                </tbody>
                                

                            </table>

                        </div><!--end /tableresponsive-->
                    </div><!--end card-body-->
                </div><!--end card-->
            </div><!--end col-->


        </div><!--end row-->





    </div><!-- Page content Wrapper -->
</div><!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->


