<?php
session_start();
include '../assets/constant/config.php';

try {
  $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>

<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->

<div class="page-content-wrapper ">

  <div class="container-fluid">

    <div class="row">
      <div class="col-sm-12">
        <div class="page-title-box">
          <div class="btn-group float-right">


          </div>
          <h4 class="page-title">Edit Campaign </h4>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
    <!-- end page title end breadcrumb -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">

            <div class="tab-content">

              <div class="tab-pane active p-3" id="home" role="tabpanel">
                <form name="myform" action="app/campaign_crud.php" class="row" method="POST" enctype="multipart/form-data" onsubmit="return validation()" id="add_service">
                  <?php
                  $stmt = $conn->prepare("SELECT * FROM `campaign` WHERE id=? ");
                  $stmt->execute([$_POST['id']]);
                  $record = $stmt->fetchAll();

                  foreach ($record as $key) { ?>
         
         <input class="form-control" type="hidden" name="id" value="<?php echo $key['id']; ?>">
                  
                   
                  <div class="form-group col-md-6">
                    <label class="control-label">Name<span class="text-danger">*</span></label>
                    <input class="form-control" type="text" name="cam_name" value="<?php echo $key['cam_name'];?>" >
                  </div>
                  <div class="form-group col-md-6">
                    <label class="control-label">Goal</label>
                    <input class="form-control" type="text" name="goal" value="<?php echo $key['goal'];?>">
                  </div>
                    <div class="form-group col-md-6">
                    <label class="control-label">Start Date</label>
                    <input class="form-control" type="date" name="sdate" value="<?php echo $key['sdate'];?>">
                  </div>
                      <div class="form-group col-md-6">
                    <label class="control-label">End Date</label>
                    <input class="form-control" type="date" name="edate" value="<?php echo $key['edate'];?>">
                  </div>
                      <div class="form-group col-md-6">
                                    <label>Notes<span class="text-danger">*</span></label>
                                    <textarea name="notes"  cols="20" rows="10" class="form-control text-area-5"><?php echo $key['notes'];?></textarea>
                                     </div>

     <div class="form-group col-sm-6">
                         <label class="control-label">Status<span class="text-danger">*</span></label>
                          <select class="form-control" name="status">
                        <option value="">Select gender</option>
                        <option <?php  if($key['status']=="0"){ echo "selected";}?> value="0">Open</option>
                        <option <?php  if($key['status']=="1"){ echo "selected";}?> value="1" >Close</option>
                       
                        </select>
                        </div>
                             <div class="form-group col-md-12">

                    <button class="btn btn-primary" type="submit" name="update" onclick="addService()">Update</button>

                  </div>
                  <?php } ?>
                </form>
              </div>


            </div>

          </div>
        </div><!--end card-->
      </div><!--end col-->
    </div><!--end row-->
  </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->
<script>
function addService() {
        jQuery.validator.addMethod("alphanumeric", function(value, element) {
            return this.optional(element) || /^(?=.[a-zA-Z])[a-zA-Z0-9\s!@#$%^&()_-]+$/.test(value);
        }, "Please enter alphanumeric characters only");

        jQuery.validator.addMethod("lettersonly", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\s]*$/.test(value);
        }, "Please enter alphabet characters only");
  
    $('#add_service').validate({
      rules: {
        cam_name: {
          required: true,
          alphanumeric: true
        },
       goal: {
          required: true
          
        },
         sdate: {
          required: true
         
        },
         edate: {
          required: true
         
        },
        notes: {
          required: true,
          alphanumeric: true
        },
        status: {
          required: true
        }
      },
      messages: {
        cam_name: {
          required: "Please enter the name",
          alphanumeric: "Only alphanumeric characters are allowed"
        },
        notes: {
          required: "Please enter the notes"
        }
      }
    });
}
</script>