<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_POST['submit'])) {

        $filepath = "../../assets/images/" . htmlspecialchars($_FILES["photo"]["name"], ENT_QUOTES, 'UTF-8');

        if (move_uploaded_file($_FILES["photo"]["tmp_name"], $filepath)) {
            $img = htmlspecialchars($_FILES["photo"]["name"], ENT_QUOTES, 'UTF-8');
        } else {
            echo "Error !!";
        }


     


        $stmt = $conn->prepare("INSERT INTO `service`(`heading`,`short_content`,`photo` , `metatitle`,`metadescription`,`keywords`,`robots`) VALUES (?,?,?,?,?,?,?)");

        $stmt->execute([
           
            htmlspecialchars($_POST['heading'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['short_content'], ENT_QUOTES, 'UTF-8'),
           
            $img,
        
            htmlspecialchars($_POST['metatitle'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['metadescription'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['keywords'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['robots'], ENT_QUOTES, 'UTF-8'),
         
        ]);

        $_SESSION['success'] = "success";

        header("location:../manage_service.php");
    }

    if (isset($_POST['update'])) {
        // Update main photo
        if (!empty($_FILES['photo']['tmp_name'])) {
            $file_extension = pathinfo($_FILES["photo"]["name"], PATHINFO_EXTENSION);
            $new_filename = uniqid() . '.' . $file_extension;
            $filepath = "../../assets/images/" . $new_filename;
            if (move_uploaded_file($_FILES["photo"]["tmp_name"], $filepath)) {
                $img = $new_filename;
                @unlink("../../assets/images/" . htmlspecialchars($_POST['old_photo_img'], ENT_QUOTES, 'UTF-8'));
            } else {
                // Handle failed upload
                // You might want to add error handling here
            }
        } else {
            // Keep the old photo if no new one is uploaded
            $img = htmlspecialchars($_POST['old_photo_img'], ENT_QUOTES, 'UTF-8');
        }
    
        // Update secondary photo
       
    
        // Prepare and execute the SQL update statement
        $stmt = $conn->prepare("UPDATE `service` SET `heading`=?, `short_content`=?,`photo`=?,`metatitle`=?,`metadescription`=?, `keywords`=?, `robots`=? WHERE id=? ");
        $stmt->execute([
            htmlspecialchars($_POST['heading'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['short_content'], ENT_QUOTES, 'UTF-8'),
           
            $img,
            htmlspecialchars($_POST['metatitle'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['metadescription'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['keywords'], ENT_QUOTES, 'UTF-8'),
            htmlspecialchars($_POST['robots'], ENT_QUOTES, 'UTF-8'),
     
            htmlspecialchars($_POST['id'], ENT_QUOTES, 'UTF-8')
        ]);
    
        $_SESSION['update'] = "update";
        header("location:../manage_service.php");
    }
    

    if (isset($_POST['del_id'])) {

        $stmt = $conn->prepare("UPDATE `service` SET delete_status='1' where id=? ");

        $stmt->execute([htmlspecialchars($_POST['del_id'], ENT_QUOTES, 'UTF-8')]);

        $_SESSION['delete'] = "delete";

        header("location:../manage_service.php");
    }
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
