<?php
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Fetch events from the database
    $stmt = $conn->prepare("SELECT ename AS title, start_date AS start, end_date AS end FROM event");
    $stmt->execute();
    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Output events in JSON format with required fields
    $formatted_events = [];
    foreach ($events as $event) {
        $formatted_event = [
            'title' => $event['title'],
            'start' => $event['start'],
            'end' => $event['end']
            // You can add more fields here if needed
        ];
        $formatted_events[] = $formatted_event;
    }

    echo json_encode($formatted_events);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}
?>