<?php
session_start();
include '../../assets/constant/config.php';

try {
    $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_POST['submit'])) {
   

        $stmt = $conn->prepare("INSERT INTO `career`(`heading`, `location`, `department`, `description`, `time`) VALUES (?, ?,?,?,?)");
        $stmt->execute([$_POST['heading'],$_POST['location'],$_POST['department'],$_POST['description'],$_POST['time']]);

        $_SESSION['success'] = "success";

        header("location:../manage_career.php");
    }

    if (isset($_POST['update'])) {
   

        $stmt = $conn->prepare("UPDATE `career` SET `heading`=?,`location`=?,`department`=?,`description`=?,`time`=? WHERE id=?");
        $stmt->execute([$_POST['heading'],$_POST['location'],$_POST['department'],$_POST['description'],$_POST['time'],$_POST['id']]);

        $_SESSION['update'] = "update";

        header("location:../manage_career.php");
    }

    if (isset($_POST['del_id'])) {
        $id = htmlspecialchars($_POST['del_id']);
        $stmt = $conn->prepare("UPDATE `career` SET delete_status='1' where id=?");
        $stmt->execute([$id]);

        $_SESSION['delete'] = "delete";

        header("location:../manage_career.php");
    }
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
    // Display a generic error message
    echo "An error occurred. Please try again later.";
}
