<?php
session_start();
include '../assets/constant/config.php';

try {
  $conn = new PDO("mysql:host=$servername;dbname=$dbname", $username, $password);
  $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  echo "Connection failed: " . $e->getMessage();
}
?>
<?php include('include/sidebar.php'); ?>

<?php include('include/header.php'); ?>

<!--  connect author at mdkhairnar92@gmail.com  -->

<div class="page-content-wrapper ">

  <div class="container-fluid">

    <div class="row">
      <div class="col-sm-12">
        <div class="page-title-box">
          <div class="btn-group float-right">


          </div>
          <h4 class="page-title">Add Follow Up</h4>
        </div>
      </div>
      <div class="clearfix"></div>
    </div>
    <!-- end page title end breadcrumb -->
    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">

            <div class="tab-content">

              <div class="tab-pane active p-3" id="home" role="tabpanel">

                <form name="myform" action="app/followup_crud.php" class="row" method="POST" enctype="multipart/form-data" onsubmit="return validation()" id="add_service">

                  
                            <div class="form-group col-md-6">
                    <label for="id_label_multiple">Branch<span class="text-danger">*</span> </label>
                    <select class="form-control postName select2" id="role" aria-label="Default select example" type="text" name="branch">
                      <option value="">Select branch</option>
                      <?php
                      $sql1 = $conn->prepare("select * from `branch` where delete_status='0' ");
                      $sql1->execute();
                      $row1 = $sql1->fetchAll();
                      foreach ($row1 as $key1) {
                      ?>
                        <option value="<?php echo $key1['branch_name']; ?> ">
                          <?php echo $key1['branch_name']; ?>
                        </option>
                      <?php } ?>
                    </select>
                  </div>
                    <div class="form-group col-md-6">
                              <label for="id_label_multiple">member<span class="text-danger">*</span> </label>
                              <select class="form-control postName select2" id="member" aria-label="Default select example" type="text" name="member" >
                              <option value="">Select member</option>
                               <?php    
                                $sql1=$conn->prepare("select * from `member` where delete_status='0' ");
                                $sql1->execute();
                                $row1=$sql1->fetchAll();
                                //print_r($row);
                                //exit;
                                foreach ($row1 as $key1) {?>
                                <option value="<?php echo $key1['name'];?> ">
                                       <?php echo $key1['name'];?>
                                        </option>
                                    <?php } ?>
                              </select>
                           </div>
                                 <div class="form-group col-md-6">
                              <label for="id_label_multiple">category<span class="text-danger">*</span> </label>
                              <select class="form-control postName select2" id="category" aria-label="Default select example" type="text" name="category" >
                              <option value="">Select category</option>
                               <?php    
                                $sql1=$conn->prepare("select * from `followup_category` where delete_status='0' ");
                                $sql1->execute();
                                $row1=$sql1->fetchAll();
                                //print_r($row);
                                //exit;
                                foreach ($row1 as $key1) {?>
                                <option value="<?php echo $key1['name'];?> ">
                                       <?php echo $key1['name'];?>
                                        </option>
                                    <?php } ?>
                              </select>
                           </div>
                           <div class="form-group col-md-6">
                              <label for="id_label_multiple">Assigned To<span class="text-danger">*</span> </label>
                              <select class="form-control postName select2" id="user" aria-label="Default select example" type="text" name="user" >
                              <option value="">Select </option>
                               <?php    
                                $sql1=$conn->prepare("select * from `user` where delete_status='0' ");
                                $sql1->execute();
                                $row1=$sql1->fetchAll();
                                //print_r($row);
                                //exit;
                                foreach ($row1 as $key1) {?>
                                <option value="<?php echo $key1['username'];?> ">
                                       <?php echo $key1['username'];?>
                                        </option>
                                    <?php } ?>
                              </select>
                           </div>

                           <div class="form-group col-sm-6">
                         <label class="control-label">Status<span class="text-danger">*</span></label>
                          <select class="form-control" name="status">
                        <option value="">Select </option>
                        <option value="0">completed</option>
                        <option value="1">incompleted</option>
                       
                        </select>
                        </div>

                           <div class="form-group col-md-6">
                                    <label>Description<span class="text-danger">*</span></label>
                                    <textarea name="description"  class="form-control text-area-5" placeholder="Enter description"></textarea>
                                     </div>


                   
                  </div>


 <div class="form-group col-md-12">

                    <button class="btn btn-primary" type="submit" name="submit" onclick="addService()">Save</button>

                  </div>
                </form>
              </div>


            </div>

          </div>
        </div><!--end card-->
      </div><!--end col-->
    </div><!--end row-->
  </div> <!-- Page content Wrapper -->
</div> <!-- content -->

<?php include('include/footer.php'); ?>
<!--  Author Name: Mayuri K. 
 for any PHP, Codeignitor or Laravel website or software development contact me at mayuri.infospace@gmail.com  -->


<script>
function addService() {
        jQuery.validator.addMethod("alphanumeric", function(value, element) {
            return this.optional(element) || /^(?=.[a-zA-Z])[a-zA-Z0-9\s!@#$%^&()_-]+$/.test(value);
        }, "Please enter alphanumeric characters only");

        jQuery.validator.addMethod("lettersonly", function(value, element) {
            return this.optional(element) || /^[a-zA-Z\s]*$/.test(value);
        }, "Please enter alphabet characters only");
  
    $('#add_service').validate({
      rules: {
        branch: {
          required: true,
          alphanumeric: true
        },
       member: {
          required: true,
          alphanumeric: true
        },
        category: {
          required: true,
          alphanumeric: true
        },
        user: {
          required: true,
          alphanumeric: true
        },
        status: {
          required: true
          
        },

description: {
          required: true
        }
      },
      messages: {
        branch: {
          required: "Please select a branch",
          alphanumeric: "Only alphanumeric characters are allowed"
        },
        description: {
          required: "Please enter the description"
        }
      }
    });
}
</script>